% Caudal fin confocal quantification Matlab Script
% Date: 03/12/2021
% version: 1.0.0
% Telmo Pereira
% telmo.pereira@nms.unl.pt - CEDOC/Nova Medical School - NMS
% 
% Database file template:
% S(X).name = 'name';            %filename
% S(X).MinPeakDistance = number; % distance between peaks
% S(X).rays = [];                % rays to analyse
% S(X).loc = 100;                % start location
% S(X).corrected = [];           % manual data curation : identified peaks are ignored/removed : format [ray peak; ray2 peak2; ..]
% S(X).z_bf = 16;                % Z position of the brightfield image
% S(X).areaopen = 400;           % Remove connected components smaller than this number

clearvars -except V
filepath = 'D:\Users\Telmo\Downloads\AnaSofia\Live imaging pOc2\';
results=[];

% Database number
M = [];
show = 1;

% Main batch cycle
for batch = 1:length(M)
    N=M(batch);
    
    if N< 50
        type = 1; %condition
    else
        type = 0; %controls
    end
    
    files = V(N).name;
    Img = openimg([filepath files '.tif']);
    InfoImage=imfinfo([filepath files '.tif']);
    C1 = Img(:,:,1:2:end);
    C2 = Img(:,:,2:2:end);
    Img_channels = cat(4,C1,C2);

    % open lines file
    Datapoints = readmatrix([filepath files '.csv']);
    Datapoints1 = Datapoints(1:2:end,2:3);
    Datapoints2 = Datapoints(2:2:end,2:3);
    Datapoints_xy = cat(3,Datapoints1,Datapoints2) .* InfoImage(1).XResolution; %in pixel coordinates

    cMap = interp1([0;1],[0 0 0; 0 1 0],linspace(0,1,256));
    
    % Image preparation
    Img_test1 = max(Img_channels,[],3); %gfp
    Img_test1 = Img_test1(:,:,:,1); %gfp max proj
    Img_test2 = Img_channels(:,:,V(N).z_bf,2); %BF
    Img_gauss1 = imgaussfilt(Img_test1,10);
    Img_gauss2 = imgaussfilt(Img_test2,2);


        
    % Show images
    if show
        figure
        h1 = imshow(imadjust(Img_test2));
        hold on
        h=imshow(ind2rgb(im2uint8((imadjust(Img_gauss1))),cMap));
        set(h1, 'AlphaData', 1.0); %bf
        set(h, 'AlphaData', 0.1); %gfp
    end
    
    % Main cycle initialization
    aux=[];
    locations = zeros(size(Datapoints1,1),10);
    distance = round(norm([Datapoints_xy(i,1,1) Datapoints_xy(i,2,1)]-[Datapoints_xy(i,1,2) Datapoints_xy(i,2,2)]));
    for i=V(N).rays
        %Image profiles    
        [cx1,cy1,~] = improfile(Img_gauss1,[Datapoints_xy(i,1,1) Datapoints_xy(i,1,2)],[Datapoints_xy(i,2,1) Datapoints_xy(i,2,2)],distance);
        profaux1 = [];
        for u = -30:30
            [~,~,profaux] = improfile(Img_gauss1,[Datapoints_xy(i,1,1)+u Datapoints_xy(i,1,2)],[Datapoints_xy(i,2,1)+u Datapoints_xy(i,2,2)],distance);
            profaux1 = cat(2,profaux1,profaux);
        end
        prof1{i} = sum(profaux1,2);
        [cx2,cy2,~] = improfile(Img_gauss2,[Datapoints_xy(i,1,1) Datapoints_xy(i,1,2)],[Datapoints_xy(i,2,1) Datapoints_xy(i,2,2)],distance);
        BW = edge(Img_gauss2,'Sobel','vertical');
        BW1 = imdilate(BW,[0,1,0;0,1,0;1,1,1;0,1,0;0,1,0]);
        BW2 = bwareaopen(BW1,V(N).areaopen);

        profaux2 = [];
        distance = round(norm([Datapoints_xy(i,1,1) Datapoints_xy(i,2,1)]-[Datapoints_xy(i,1,2) Datapoints_xy(i,2,2)]));
        for u = -30:30
            [~,~,profaux] = improfile(BW2,[Datapoints_xy(i,1,1)+u Datapoints_xy(i,1,2)],[Datapoints_xy(i,2,1)+u Datapoints_xy(i,2,2)],distance);
            profaux2 = cat(2,profaux2,profaux);
        end
        profaux3 = imgaussfilt(profaux2,4);
        prof2{i} = mean(profaux3,2);

        idx = find(prof1{i}>mean(prof1{i}(1:10,1))*2,1,'first');
        if show
            plot(cx1(idx),cy1(idx),'m*')
            plot(Datapoints_xy(i,1,1),Datapoints_xy(i,2,1),'r*')
            plot(Datapoints_xy(i,1,2),Datapoints_xy(i,2,2),'g*')
        end
        
        % Finding peaks
        [peaks,loc] = findpeaks(prof2{i},'MinPeakDistance', V(N).MinPeakDistance,'MaxPeakWidth',50,'Threshold',0);
        
        % Manual Corrections
        loc(loc< V(N).loc) = [];
        for cor = 1:size(V(N).corrected,1)
            if S(N).corrected(cor,1) == i
                loc(V(N).corrected(cor,2)) = [];
            end
        end
        if loc(1) > idx
            locations(i,1:length(loc)+1) = [idx;loc];
        else
            locations(i,1:length(loc)) = [loc];
        end
        if show
            for u=1:length(loc)
                plot(cx2(loc(u)),cy2(loc(u)),'c*')
            end
        end
        
        % Data processing for 1st and 2nd bone segment
        for m = 1:2
            a1= cumsum((prof1{i}(locations(i,m):locations(i,m+1),1)));
            center_idx = find(a1>a1(end)/2,1);
            if show
                plot(cx2(locations(i,m)+center_idx),cy2(locations(i,m)+center_idx),'yo')
            end
            aux(m,:) = [locations(i,m+1)-locations(i,m) 1-(center_idx/(locations(i,m+1)-locations(i,m)))];
        end
        aux1 = [type N i aux(1,1)./InfoImage(1).XResolution aux(2,1)./InfoImage(1).XResolution aux(1,2) aux(2,2)];
        results = cat(1,results,aux1);
        aux=[];
    end
    if show
        hold off
    end
    toc
end